/*
//------------------------------------------------------------------------

	charts.as
	version 1.0

	Copyright (C) 2008, Juan Jesus G. Hinestrosa (soitu.es)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

//------------------------------------------------------------------------
*/


	var chartContainerX:Number; 			///< x position of the chart in the movie
	var chartContainerY:Number;				///< y position of the chart in the movie
	var chartContainerHeight:Number;		///< chart container height
	var chartContainerWidth:Number;			///< chart container width

	/** Time variables **/
	var timeCounter:Number; 				///< elapsed time since the movie load in seconds
	var timeCounterDate:Date = new Date(); 	///< auxiliar variable for retrieven current time at each time step
	var previousSeconds:Number; 			///< auxiliar variable storing previos elapsed time in seconds


	/** Main movie clips **/
	var chartContainerClip:MovieClip; 	///< main container movie clip
	var pieChartClip:MovieClip; 		///< pie chart movie clip
	var barsChartClip:MovieClip;		///< bars chart movie clip
	var pieWedgeClip:MovieClip;			///< each of the wedges of a pie chart
	var axisClip:MovieClip;				///< reference frame and reference lines for bars chart
	var chartHeaderClip:MovieClip;		///< header movie clip
	var chartFooterClip:MovieClip;		///< footer movie clip
	var pieLegendClip:MovieClip;		///< legend movie clip, used when not all labels fit into the pie chart clip (to avoid overlaping)

	/** Data variables **/
	var totalData:Number; 				///< Number of pieces of information (bars in a bars chart or wedges in a pie chart)

	var dataGraphicalSize:Array; 		///< Size of each piece of information on the screen (degrees if a wedge, pixels if a bar)
	var pieWedgeDegreeIni:Array; 		///< Initial position of each wedge in degrees
	var pieWedgeSize:Array; 			///< Size of each piece of information during animation (incremented from 0 to dataGraphicalSize)
	var barSize:Array;					///< Size of each piece of information during animation (incremented from 0 to dataGraphicalSize)

	var dataTotalAmount:Number; 		///< total amount of data, required for rules of three

	var i:Number; 					///< Auxiliar counter variable

	var pieCenterX:Number; 		///< Pie chart center x coord.
	var pieCenterY:Number;		///< pie chart center y coord.
	var pieRadius:Number; 		///< Pie chart radius

	var defaultLabelWidth:Number; 	///< Maximum width for a label
	var defaultLabelHeight:Number;	///< Maximum height for a label

	var PIE_LABEL_SEPARATION:Number; 	///< label radial offset from pie
	var PIE_LINE_LABEL_LENGTH:Number; 		///< length of the line connecting each label with the pie

	var SMALL_LABELS_PAR_ROW:Number;		///< number of labels per row on the lower legend
	var PIE_LEGEND_BOX_WIDTH:Number;		///<  width the legend where we will put the data that does not fit
	var PIE_LEGEND_BOX_HEIGHT:Number;		///<  height the legend where we will put the data that does not fit
	var PIE_LEGEND_BOX_SEPARATION:Number;	///<  separation between pieces of information on the legend

	var lineClip:MovieClip; 				///< auxiliar horizontal dotted line for bars chart
	var boxLetteringClip:MovieClip;

	var drawingChart:Boolean; 				///< flag which is true when the chart is being drawn

	var separationBetweenBars:Number; 	    ///< bars separation in pixels
	var barWidth:Number; 					///< width of each bar
	var barTotalWidth:Number; 				///< width of each bar + lateral margin
	var maxLabelWidth:Number;				///< maximum width of label
	var chartType:String;  					///< define the type of chart to be represented: pie or bars

	var dataValue:Array; 				///< raw data values to be displayed
	var dataNumberGrowing:Array; 		///< data values, goes from 0 to the final value, necessary for the animation
	var dataName:Array; 				///< contains the names of the pieces of information to be represented

	var graphicalElementIncrement:Array; ///< increment wich we will use for each bar or wedge (animation)

	var LEFT_MARGIN_BARS:Number; 		// left margin for bars chart (from chartContainerX to the first bar)

	var labelVisible:Array = new Array(); 	///< when the corresponding label doesn't fit in the graph, the value is false

	var pieDepth:Number; 					///< depth inside the pie

	var degreesToRadians = Math.PI / 180; 		///< conversion factor between degrees and radians (for angle operations)

	var MAX_DEGREE:Number; ///< maximum degree, 360 if we are painting a complete circle
	var DEGREE_INI:Number; ///< tarting degree, where we start to draw the first wedge

	var depthIni:Number; 				///< movie clip depth

	var subtraction:Number;  /// auxiliar var

	var chart_value:Array;  ///< main data values got from XML file. we will use this data for draw the chart
	var chart_value_secondary:Array;  ///< secondary and optional data values got from XML file. we will only use this data in tooltips


	/** Obtains a new color
	*	This functions picks a new color from colors array
	*	@param whichOne
	*	@return The id of the color to be used
	*/
	function whatColor(whichOne:Number):Number {
		whichOne --;
		if (whichOne >= colors.length)
			return ( whichOne - ( ( Math.floor ( whichOne / colors.length ) * colors.length ) ) );
		else
			return(whichOne);
	}

	/** Draws a wedge in a pie chart
	*	@param pieCenterX pie center x coord.
	*	@param pieCenterY pie center y coord.
	*	@param pieRadius pie chart radius
	*	@param startDegree
	*	@param archAngle
	*	@param idWedge
	*	@param steps
	*/
	function paintPieWedge(pieCenterX:Number, pieCenterY:Number, pieRadius:Number, startDegree:Number, archAngle:Number, idWedge:Number, steps:Number){
		// degreesToRadians is used to convert degress to radians
		// a whole circle is 360 degrees or 2*pi radians
		// half circle is 180 degrees or pi radians
		// y(radians) = x(degrees) * (pi/180);
		var coorx:Number;
		var coory:Number;
		// pie chart container creation
		pieWedgeClip = pieChartClip.createEmptyMovieClip("pieWedgeClip" + idWedge, pieDepth);
		pieDepth++;

		wedgeColour = colors[whatColor(idWedge)];

		pieWedgeClip.beginFill(wedgeColour,100);

		// translation to the pie chart center
		pieWedgeClip.moveTo(pieCenterX, pieCenterY);

		// go to the first arch position
		coorx = pieCenterX + Math.cos(startDegree * degreesToRadians) * pieRadius;
		coory = pieCenterY + Math.sin(startDegree * degreesToRadians) * pieRadius;

		pieWedgeClip.lineTo(coorx, coory);

		// draw the curve, in 1 degree steps
		for(var suma = steps; suma <= archAngle; suma ++)
			{
				// go from (startDegree) to (startDegree + archAngle)
				var angle = startDegree + suma;

				// next curve coordinates
				coorx = pieCenterX + Math.cos(angle * degreesToRadians) * pieRadius;
				coory = pieCenterY + Math.sin(angle * degreesToRadians) * pieRadius;

				pieWedgeClip.lineTo(coorx, coory);

			}

		// complete the arch until the decimal value
		coorx = pieCenterX + Math.cos((startDegree+archAngle) * degreesToRadians) * pieRadius;
		coory = pieCenterY + Math.sin((startDegree+archAngle) * degreesToRadians) * pieRadius;
		pieWedgeClip.lineTo(coorx, coory);

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function printPieLabels():Void { ///< print all pie labels. if one in particular does not fit, we don't show it

		var currentDegree:Number;

		var tempx:Number;
		var tempy:Number;
		var labelXPie:Number;
		var labelYPie:Number;
		var thisLabelWidth:Number;
		var thisLabelHeight:Number;
		var instance1:MovieClip;
		var instance2:MovieClip;
		var labelOnTheLeft:Boolean;
		var labelOnTheRight:Boolean;

		labelOnTheLeft =
		labelOnTheRight = false;

		for (i = 1; i <= totalData; i++) {

			currentDegree = pieWedgeDegreeIni[i] + (pieWedgeSize[i] / 2); ///< where are we

			labelOnTheLeft = labelOnTheRight = false;

			if (currentDegree > MAX_DEGREE) currentDegree -= MAX_DEGREE; ///< if degree is greater than 360, we fix it

			if ((currentDegree >= 90) && (currentDegree <= 270)) labelOnTheLeft = true; ///< check where the label is, left or right

			labelOnTheRight = !labelOnTheLeft;

			var myTextFormat:TextFormat = new TextFormat();

			myTextFormat.color = 0x00000;
			myTextFormat.font = "Arial";
			myTextFormat.size = font_size_labels;

			if(labelOnTheRight) myTextFormat.align = "left";
			if(labelOnTheLeft) myTextFormat.align = "right";

			lineClip = pieWedgeClip.createEmptyMovieClip("lineClip" + i, pieWedgeClip.getNextHighestDepth()); ///< line that indicates what wedge we are labeling

			lineClip.lineStyle(1,0x6A6A6A);

			tempx = pieCenterX + Math.cos ( currentDegree * degreesToRadians ) * ( pieRadius - ( 5 ) - subtraction ) ;
			tempy = pieCenterY + Math.sin ( currentDegree * degreesToRadians ) * ( pieRadius - ( 5 ) - subtraction );

			lineClip.moveTo(tempx,tempy);

			tempx = pieCenterX + Math.cos ( currentDegree * degreesToRadians ) * ( pieRadius + ( PIE_LABEL_SEPARATION ) ) ;
			tempy = pieCenterY + Math.sin ( currentDegree * degreesToRadians ) * ( pieRadius + ( PIE_LABEL_SEPARATION ) ) ;

			lineClip.lineTo(tempx, tempy);


			labelWedgeClip = pieWedgeClip.createEmptyMovieClip("valorClip" + i, pieWedgeClip.getNextHighestDepth());
			labelClip = labelWedgeClip.createTextField("valor" + i, pieWedgeClip.getNextHighestDepth() , 0, tempy - (defaultLabelHeight / 2), defaultLabelWidth, defaultLabelHeight);

			labelWedgeClip["valor" + i].selectable = false;
			labelWedgeClip["valor" + i].text = dataName[i] + " (" + beautifyNumber(dataValue[i]) + ")" ;

			labelWedgeClip["valor" + i].setTextFormat(myTextFormat);
			labelWedgeClip["valor" + i].autoSize = true;

			if (labelOnTheRight) ///< horizontal line that continues the previous one
				{
					lineClip.lineTo(tempx + PIE_LINE_LABEL_LENGTH, tempy);
					labelWedgeClip["valor" + i]._x = tempx + PIE_LINE_LABEL_LENGTH;
				}
			else
				{
					lineClip.lineTo(tempx - PIE_LINE_LABEL_LENGTH, tempy);
					labelWedgeClip["valor" + i]._x = tempx - PIE_LINE_LABEL_LENGTH - labelWedgeClip["valor" + i]._width;
				}

			var instance1:MovieClip = pieWedgeClip["valorClip" + i];

			for (j = 1; j < i; j++) {	/// we must check that the current label don't collide with another

				var instance2:MovieClip = pieWedgeClip["valorClip" + j];


				if (instance1.hitTest(instance2)) // if this label collide with another ...
						{
							// ... set false labelVisible. this is a flag used for print the label on the pie legend ...
							labelVisible[i]	= false;


							// ... and hide it and its lines
							pieWedgeClip["valorClip" + i]._visible = false;
							pieWedgeClip["lineClip" + i]._visible = false;
							break;
						}
						else {
							labelVisible[i]	= true;
						}
					}

		} // end for

	} // end printPieLabels()

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function drawBox(x, y, width, height, color, filled, whatClip:MovieClip):Void {

		boxx = whatClip.createEmptyMovieClip("boxx", whatClip.getNextHighestDepth() );

		if (!filled)
			boxx.lineStyle(1, color);
			else
			boxx.beginFill(color);

		boxx.moveTo(x, y);
		boxx.lineTo(x + width, y);
		boxx.lineTo(x + width, y + height);
		boxx.lineTo(x, y + height);
		boxx.lineTo(x, y);
	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function printPieLegend():Void { ///< print the labels and colors that did not fit on the pie

		var counter:Number;
		var penX:Number;
		var pieLegendColor:Number;

		counter = 1;

		pieLegendClip = pieWedgeClip.createEmptyMovieClip("pieLegendClip", pieWedgeClip.getNextHighestDepth() );
		pieLegendClip._x = chartContainerX;
		pieLegendClip._y =  chartContainerY + chartContainerHeight - chartFooterHeight;

		penX = 0; ///< current position where we are going to print every thing (boxes and labels) remember logo ? :)
		penY = 0;

		for (i = 1; i <= totalData; i++) {

			// if this flag is false, then the label was not on the pie and we must print it
			if ( ! labelVisible[i] ) {

				currentLabelClip = pieLegendClip.createEmptyMovieClip( "currentLabelClip" + i , pieLegendClip.getNextHighestDepth() );

				pieLegendColor = colors[whatColor(i)];

				// paint the small box using the same colour of the wedge
				drawBox(0, 0, PIE_LEGEND_BOX_WIDTH, PIE_LEGEND_BOX_HEIGHT, pieLegendColor, true, currentLabelClip);

				currentLabelClip._x = penX;
				currentLabelClip._y = penY;

				legendLabel = currentLabelClip.createTextField("legendLabel" + counter, pieLegendClip.getNextHighestDepth(), PIE_LEGEND_BOX_WIDTH + PIE_LEGEND_BOX_SEPARATION, 0, defaultLabelWidth, defaultLabelHeight);

				currentLabelClip["legendLabel" + counter].text = dataName[i];

				var myTextFormat:TextFormat = new TextFormat();
				myTextFormat.color = 0x000000;
				myTextFormat.font = "Arial";
				myTextFormat.size = font_size_labels;

				myTextFormat.align = "left";

				currentLabelClip["legendLabel" + counter].setTextFormat(myTextFormat);

				currentLabelClip["legendLabel" + counter].autoSize = true;

				// increment penX using label width and separation
				penX += currentLabelClip._width + ( PIE_LEGEND_BOX_SEPARATION * 3 );

				// time to increment the row and re-position the last label
				if ( ( penX - ( PIE_LEGEND_BOX_SEPARATION * 3 ) ) > ( chartContainerX + chartContainerWidth ) ) {

					penX = 0;
					penY += currentLabelClip._height + PIE_LEGEND_BOX_SEPARATION;
					currentLabelClip._x = penX;
					currentLabelClip._y = penY;
					penX += currentLabelClip._width;

				}

				counter++;

			}

		}


	}
	// --------------------------------------------------------------------------------------------------------------------------------------------

	function createTip():Void {  ///< create the tip we show when you move the mouse over something

		tip = chartContainerClip.createEmptyMovieClip("tip", chartContainerClip.getNextHighestDepth()+10);

		tip.createEmptyMovieClip("tip", 1);

		tip._alpha = 90;

		tip.endFill();

		tip.createTextField("texto", 2, 0, 0, defaultLabelWidth * 2, tip._height);

		tip.texto.selectable = false;
		tip.texto.multiline = true;

		tip.autoSize = true;
		tip.texto.wordWrap = true;
		tip.texto.background = true;
		tip.texto.backgroundColor = 0x333333;


	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function showTip(whatText:String):Void { ///< show the tip we show when you move the mouse over something

		var myTextFormat:TextFormat = new TextFormat();
		myTextFormat.color = 0xFFFFFF;
		myTextFormat.font = "Arial";
		myTextFormat.size = font_size_tips;
		myTextFormat.align = "left";


		tip._visible = true;
		tip.texto.text =  whatText;
		tip.texto.autoSize = true;
		tip.texto.setTextFormat(myTextFormat);

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function enableChartTooltips():Void { ///< enable the 'tooltips' for the bars and wedges

		var currentChartClip:MovieClip;
		var textTip:String;

		createTip();

		if (chartType == "pie") {  ///< first, find out in what movieclip we place the tooltip
				currentChartClip = pieChartClip;
				pieceClip = "pieWedgeClip";
			}
			else
			{
				currentChartClip = barsChartClip;
				pieceClip = "barClip";
			}

		for(i=1; i <= totalData; i++) {

					currentChartClip[pieceClip + i ].i = i;


					currentChartClip[pieceClip + i].onRollOver = function(){ ///< add the events to the wedges or bars: on mouse over, show the tip
						this._alpha = 70; ///< change wedge/bar alpha
						textTip = dataName[this.i];
						if (chartType == "pie") textTip += " (" + beautifyNumber(dataValue[this.i]) + ") ";;
						if (name_value_secondary != "") textTip += " " + beautifyNumber(chart_value_secondary[this.i]) + " " + name_value_secondary;
						showTip (textTip);
					}

					currentChartClip[pieceClip + i].onRollOut = function() { ///< on mouse out, hide the tip
						tip._visible = false;
						this._alpha = 100;
					}

					if ( ( chartType == "pie") && ( !labelVisible[i]) ) { ///< we must enable the pie legend tips too

						pieLegendClip["currentLabelClip" + i ].i = i;


						pieLegendClip["currentLabelClip" + i].onRollOver = function(){ ///< on mouse out, show the tip

							this._alpha = 70;
							textTip = dataName[this.i] + " (" + dataValue[this.i] + ") ";
							if (name_value_secondary != "") textTip += + beautifyNumber(chart_value_secondary[this.i]) + " " + name_value_secondary;
							showTip ( textTip );

						}

						// on mouse over, hide the tip
						pieLegendClip["currentLabelClip" + i].onRollOut = function() {

							tip._visible = false;
							this._alpha = 100;

						}

					}

		}

		tip._visible = false; ///< by now, hide the tip

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function tipWorking():Void { ///< set the tip position and avoid that it goes out of the screen

		tip._x = _xmouse - (tip._width / 2);
		tip._y = _ymouse + (tip._height);
		if (tip._x + (tip._width) > (chartContainerWidth + chartContainerX)) tip._x = (chartContainerWidth + chartContainerX) - tip._width;
		if (tip._x < chartContainerX ) tip._x = chartContainerX;
		if (tip._y + (tip._height) > ( chartContainerHeight + chartContainerY) ) tip._y = _ymouse - (tip._height);

	}


	// --------------------------------------------------------------------------------------------------------------------------------------------


	function initPieChart():Void { ///< tasks to do before start painting the pie chart

		var currentDegree:Number;
		var valorActual:Number;

		MAX_DEGREE = 360; ///< defines max degree of the pie. 360 if you want a complete circle
		DEGREE_INI = 45; ///< where we start to paint the pie
		SMALL_LABELS_PAR_ROW = 5; ///< number of labels per row on the lower legend
		PIE_LEGEND_BOX_WIDTH = 20; ///<  width the legend where we will put the data that does not fit
		PIE_LEGEND_BOX_HEIGHT = 15; ///<  height the legend where we will put the data that does not fit
		PIE_LEGEND_BOX_SEPARATION = 5; ///<  separation between pieces of information on the legend
		PIE_LABEL_SEPARATION = 20;	 ///< pie line 1 length (perpendicular line from wedge)
		PIE_LINE_LABEL_LENGTH =  20; ///< pie line 2 length (straight line to label)
		pieWedgeSize = new Array();

		dataTotalAmount = 0;

		medidaATenerEnCuenta = chartContainerHeight;
		if(chartContainerHeight>chartContainerWidth) medidaATenerEnCuenta=chartContainerWidth;

		pieRadius = ( medidaATenerEnCuenta-chartHeaderHeight-chartFooterHeight-(defaultLabelHeight*2)-(PIE_LINE_LABEL_LENGTH*2)-(PIE_LABEL_SEPARATION*2) ) / 2;


		for (i = 1; i <= totalData; i++) { ///< add up all data and store it in dataTotalAmount
			dataTotalAmount += dataValue[i];
			pieWedgeSize[i] = 0;
			labelVisible[i] = true;
		}

		pieChartClip = chartContainerClip.createEmptyMovieClip("pieChartClip",chartContainerClip.getNextHighestDepth()); ///< create the base clip for the pie

		dataGraphicalSize = new Array(); ///< size in degrees of each wedge
		pieWedgeDegreeIni = new Array(); ///< start degree of each wedge

		currentDegree = DEGREE_INI; ///< current degree




		for (i = 1; i < dataValue.length; i++) 	{ ///< calculate degree of each wedge

			dataGraphicalSize[i] = (( MAX_DEGREE * dataValue[i] ) / dataTotalAmount); ///< rule of three, 360 = totalAmountData

			pieCenterX = chartContainerX + ( chartContainerWidth / 2 ) ;
			pieCenterY = chartContainerY + chartHeaderHeight + ( chartHeight / 2 );

			pieWedgeDegreeIni[i] = currentDegree;

			currentDegree += dataGraphicalSize[i];

		}

		if ( SHOW_PIE_TOTAL ) {

			pieChartClip.attachMovie("hole", "hole1", this.getNextHighestDepth() + totalData); ///< hole where we will paint total amount of data

			pieChartClip.hole1._x = pieCenterX; ///< x coordinate of the hole where we will paint total amount of data
			pieChartClip.hole1._y = pieCenterY; ///< y coordinate of the hole where we will paint total amount of data
			pieChartClip.hole1.createTextField("total", pieChartClip.hole1.getNextHighestDepth() , 0, 0, defaultLabelWidth, defaultLabelHeight);
			pieChartClip.hole1.total.selectable = false;
			pieChartClip.hole1.total.text = dataTotalAmount;
			var myTextFormat:TextFormat = new TextFormat();
			myTextFormat.color = 0x000000;
			myTextFormat.font = "Arial";
			myTextFormat.size = font_size_pie_total;
			pieChartClip.hole1.total.setTextFormat(myTextFormat);
			pieChartClip.hole1.total.autoSize = true;
			pieChartClip.hole1.total._x = - pieChartClip.hole1._width / 2;
			pieChartClip.hole1.total._y = - pieChartClip.hole1._height / 2;

			pieChartClip.hole1.total._visible = false; ///< we will show the text when the white ball animation ends

			if (pie_hole_size == -1) pie_hole_size = pieChartClip.hole1._width * 1.2;
			pieChartClip.hole1.ball._xscale = pie_hole_size;
			pieChartClip.hole1.ball._yscale = pie_hole_size;

			pieChartClip.hole1.ball._x = - pieChartClip.hole1.ball._width / 2;
			pieChartClip.hole1.ball._y = - pieChartClip.hole1.ball._height / 2;



		}


	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function beautifyLimit(number):Number { // turns 25354 into 26000, 112300 into 120000, 584932492 into 590000000, etc

		i = 1;

		do {
			division = highestValue / (Math.pow(10,i));
			i++;
		}while (division >= 1);

		i -= 3;

		return ( ( Math.floor ( highestValue / Math.pow(10,i) + 1) * Math.pow(10,i)) );

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------


	function initBarsChart():Void { ///< tasks to do before start painting the bars chart

		var result:Number;
		var tempString:String;

		LEFT_MARGIN_BARS = 10;

		dataNumberGrowing = new Array(); ///< starts 0, ends when it reach the final bar size


		axisX = 0;
		axisY = 0;

		if ( rotateBarNumbers )  {  ///< if numbers are rotated, we need space
			axisY += defaultLabelWidth;
			axisHeight -= defaultLabelWidth;
		}

		axisHeight = chartContainerHeight - chartHeaderHeight - defaultLabelHeight - 10;

		chartContainerWidth -= defaultLabelHeight; ///< we have to stretch the chart depending on the width of the max value	label, so it can fit on the right

		axisWidth = chartContainerWidth;

		separationBetweenBars = (chartContainerWidth) / (totalData);
		barWidth =  ( chartContainerWidth / totalData ) / 1.5;
		barTotalWidth =  chartContainerWidth / totalData;
		maxLabelWidth = chartContainerWidth / totalData;

		barSize = new Array();

		barsChartClip = chartContainerClip.createEmptyMovieClip("barsChartClip",chartContainerClip.getNextHighestDepth()); ///< create the base clip for the bars chart

		barsChartClip._x = chartContainerX ;
		barsChartClip._y = chartContainerY + chartHeaderHeight;

		highestValue = 0;

		for (i = 1; i <= totalData; i++) { ///< check what value is the biggest, we need it to set the vertical scale
			if (dataValue[i] > highestValue) highestValue = dataValue[i];
			barSize[i] = 0;
			dataNumberGrowing[i] = 0;
		}

		if (chartBarsMaxValue == -1) ///< if this is -1, we must find out what are the upper limit
			{
				highestValue = Math.ceil (highestValue + (highestValue/15)); ///< adds more space on the top
				highestValue = beautifyLimit(highestValue);	///< and turns the number into a nice one (example: 33449 into 34000)

			}
			else  ///< if this is not -1, then the highest value comes from the xml file
			{
				highestValue = chartBarsMaxValue;
			}


		dataGraphicalSize = new Array();


		for (i = 1; i <= totalData; i++) { ///< set the height of each bar, using a rule of three
			dataGraphicalSize[i] = Math.ceil ( ( ( dataValue[i] - chartBarsMinValue ) * axisHeight ) /  ( highestValue - chartBarsMinValue)  ) ;
		}

		drawBarAxis(); ///< draw the horizontal lines

		printBarNames(); ///< print all bar labels


	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function printBarNames():Void { ///< print what is every bar

		var tempx:Number;

		var myTextFormat:TextFormat = new TextFormat();
		myTextFormat.color = 0x000000;
		myTextFormat.font = "Arial";
		myTextFormat.size = font_size_labels;
		myTextFormat.align = "center";

		for(i=1;i<=totalData;i++) {

				tempx = (( axisX +  ((i - 1) * separationBetweenBars)));

				barsChartClip.createTextField("nombre"+i, i+(totalData*2) ,tempx,axisY+axisHeight+5,maxLabelWidth,defaultLabelHeight);

				barsChartClip["nombre"+i].selectable = false;
				barsChartClip["nombre" + i].text = dataName[i];

				barsChartClip["nombre" + i].autoSize = true;
				if ( barsChartClip["nombre" + i]._width > maxLabelWidth ) ///< if the text does not fit, create a rollover to show it
				{

					barsChartClip.attachMovie("dots_clip", "dots_clip" + i, i + (totalData * 3));
					barsChartClip["dots_clip" + i].fondo._width = maxLabelWidth;
					barsChartClip["dots_clip" + i].fondo._height = barsChartClip["nombre" + i]._height;
					barsChartClip["dots_clip" + i].puntos._x = maxLabelWidth - barsChartClip["dots_clip" + i].puntos._width;
					barsChartClip["dots_clip" + i].puntos._y = 0;
					barsChartClip["dots_clip" + i]._x = tempx;
					barsChartClip["dots_clip" + i]._y = axisY + axisHeight + 5;

					barsChartClip["dots_clip" + i].i = i;

					barsChartClip["dots_clip" + i].onRollOver = function() {  ///< create event for showing the tooltip

						tip._visible = true;

						tip.texto.text = dataName[this.i];

						myTextFormat.color = 0x000000;
						myTextFormat.font = "Arial";
						myTextFormat.size = font_size_labels;
						myTextFormat.color = 0xFFFFFF;
						myTextFormat.align = "left";

						tip.texto.setTextFormat(myTextFormat);

						tip.texto.autoSize = true;

					}

					barsChartClip["dots_clip" + i].onRollOut = function(){
						tip._visible = false;
						this._alpha = 100;
					}


				}

				barsChartClip["nombre" + i].autoSize = false;
				barsChartClip["nombre" + i]._width = maxLabelWidth;

				barsChartClip["nombre" + i].setTextFormat(myTextFormat);

		}

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function printBarLabelNumbers():Void { ///< put the values containing values of each bar

		var tempx:Number;
		var tempy:Number;

		var myTextFormat:TextFormat = new TextFormat();
		myTextFormat.color = 0x000000;
		myTextFormat.font = "Arial";
		myTextFormat.size = font_size_numbers;
		myTextFormat.align = "left";

		for (i = 1; i <= totalData; i++) {

				tempx = (( axisX +  ((i - 1) * barTotalWidth))) + ( barTotalWidth / 2);   ///< label x coordinate
				tempy = axisY + axisHeight - barSize[i] - defaultLabelHeight;  ///< label y coordinate

				if(rotateBarNumbers) { ///< if we are rotating the labels, we must modify x ...
					tempx = (( axisX +  ((i - 1) * barTotalWidth))) + ( barTotalWidth / 2) - (defaultLabelHeight / 2); ///< if we are rotating the labels, we must modify x ...
					myTextFormat.align = "left";  ///< and change the text alignment
				}

				labelClip = barsChartClip.createTextField("number" + i, i + (totalData) , tempx, tempy, barTotalWidth, defaultLabelHeight);  ///< create the text label
				barsChartClip["number"+i].selectable = false;

				if (rotateBarNumbers) barsChartClip["number" + i].embedFonts = true;  ///< if we rotate text, flash needs the fonts embeded

				dataNumberGrowing[i] = Math.floor ( ( dataValue[i] * barSize[i] ) / dataGraphicalSize[i] ); ///< remove decimals

				barsChartClip["number"+i].text = beautifyNumber(dataNumberGrowing[i]); ///< add the dots
				barsChartClip["number" + i].setTextFormat(myTextFormat);
				barsChartClip["number" + i].autoSize = true;
				barsChartClip["number" + i]._x = tempx - (barsChartClip["number" + i]._width / 2);	///< modify x after the autoSized took place

				if (rotateBarNumbers) { ///< rotate numbers labels
					barsChartClip["number" + i]._rotation = 270;
					barsChartClip["number" + i]._x = ( chartContainerWidth / totalData ) * ( i - 1 ) + ( barWidth / 2);
					barsChartClip["number" + i]._y = tempy + 10;
				}

		}

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	/** Draws a bar in a bars chart
	*	@param coorx
	*	@param coory
	*	@param width of the bar, in pixels
	*	@param chartContainerHeight height of the container clip
	*	@param barId unique id of current bar. we need it for manage depths
	*/

	function paintBar(coorx:Number , coory:Number, width:Number, chartContainerHeight:Number, barId:Number):Void {

		barClip = barsChartClip.createEmptyMovieClip("barClip" + barId, barId);

		with (barClip) {

			createEmptyMovieClip("barra", depthIni);

			barra.beginFill(colors[whatColor(barId)], 100);
			barra.moveTo(coorx, coory);
			barra.lineTo(coorx, coory - chartContainerHeight);
			barra.lineTo(coorx + width, coory - chartContainerHeight);
			barra.lineTo(coorx + width, coory);
			barra.lineTo(coorx, coory);
			barra.endFill();

		}

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	/** Draws an horizontal dotted line
	*	@param coorx
	*	@param coory
	*	@param longitud of the line
	*	@param separation between dots
	*	@param alpha alpha of the line
	* *	@param where movieclip where the line will be drawn
	*/

	function drawDottedLine(coorx:Number,coory:Number,longitud:Number,separacion:Number,alpha:Number,where:String):Void {

		var diferenciador:Number = Math.floor ( Math.random()*1000 ); // esto es para que no se dupliquen los nombres de instancias cuando se hacen varias líneas
		var cadena:String;

		queprofundidad = axisClip.getNextHighestDepth();

		for (i = 1; i <= (longitud / separacion); i++) {

			cadena = "minipixel" + diferenciador + "_" + i;
			axisClip.attachMovie("minipixel", cadena, queprofundidad + i);
			setProperty(where + "." + cadena, _alpha, alpha);
			setProperty(where + "." + cadena, _x, Math.floor(coorx + (i * separacion)));
			setProperty(where + "." + cadena, _y, Math.floor(coory));
		}

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function drawBarAxis():Void { ///> draw the bars chart horizontal lines (first at minimum value, second at medium value, and third at maximum value)

		axisClip = barsChartClip.createEmptyMovieClip("axisClip",depthIni);
		barsChartClip.axisClip._x = axisX;
		barsChartClip.axisClip._y = axisY;

		var porcion:Number = axisHeight / 8;

		drawDottedLine(0,0,axisWidth,2,20,"axisClip");
		drawDottedLine(0,(porcion*4),axisWidth,2,20,"axisClip");
		drawDottedLine(0,(porcion*8),axisWidth,2,50,"axisClip");


		var myTextFormat:TextFormat = new TextFormat();
		myTextFormat.color = 0x000000;
		myTextFormat.font = "Arial";
		myTextFormat.size = font_size_numbers;
		myTextFormat.align = "center";
		myTextFormat.color = 0x949494;

		axisClip.createTextField("minimumValue", axisClip.getNextHighestDepth() , axisWidth + 5, axisHeight + defaultLabelWidth / 2, defaultLabelWidth, defaultLabelHeight);
		axisClip.minimumValue.selectable = false;
		axisClip.minimumValue.multiline = true;
		axisClip.minimumValue.embedFonts = true;
		axisClip.minimumValue._rotation = 270;
		axisClip.minimumValue.text = chartBarsMinValue;
		axisClip.minimumValue.autoSize = true;
		axisClip.minimumValue._y = axisHeight + axisClip.minimumValue._height / 2
		axisClip.minimumValue.setTextFormat(myTextFormat);


		axisClip.createTextField("mediumValue", axisClip.getNextHighestDepth() , axisWidth+5, axisHeight / 2 + defaultLabelWidth / 2  , defaultLabelWidth, defaultLabelHeight);
		axisClip.mediumValue.selectable = false;
		axisClip.mediumValue.multiline = true;
		axisClip.mediumValue.text = beautifyNumber ( Math.ceil( (highestValue + chartBarsMinValue ) / 2) );
		axisClip.mediumValue.embedFonts = true;
		axisClip.mediumValue._rotation = 270;
		axisClip.mediumValue.autoSize = true;
		axisClip.mediumValue._y = axisHeight / 2 + defaultLabelWidth / 2 + axisClip.mediumValue._height / 2
		axisClip.mediumValue.setTextFormat(myTextFormat);

		axisClip.createTextField("maximumValue", axisClip.getNextHighestDepth() , axisWidth + 5,  defaultLabelWidth / 2 , defaultLabelWidth, defaultLabelHeight);
		axisClip.maximumValue.selectable = false;

		axisClip.maximumValue.multiline = true;
		axisClip.maximumValue.text = beautifyNumber ( highestValue );
		axisClip.maximumValue.embedFonts = true;
		axisClip.maximumValue._rotation = 270;
		axisClip.maximumValue.autoSize = true;
		axisClip.maximumValue._y = defaultLabelWidth / 2 + axisClip.maximumValue._height / 2
		axisClip.maximumValue.setTextFormat(myTextFormat);


	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function printBasicLegend():Void { ///< print the title and subtitle, the common elements for both charts

		var myTextFormat:TextFormat = new TextFormat();
		var tempTexto:String;
		var titleText:String;

		myTextFormat.color = 0x000000;
		myTextFormat.font = "Arial";
		myTextFormat.size = font_size_title;

		leyendaBasica = chartContainerClip.createEmptyMovieClip("leyendaBasicaClip",chartContainerClip.getNextHighestDepth());
		leyendaBasica._x = chartContainerX;
		leyendaBasica._y = chartContainerY;

		leyendaBasica.createTextField("titulo", leyendaBasica.getNextHighestDepth() ,0,0,chartContainerWidth,defaultLabelHeight);

		titleText = "";

		titleText += chart_title;

		leyendaBasica.titulo.text = titleText;
		leyendaBasica.titulo.selectable = false;
		leyendaBasica.titulo.autoSize = true;

		leyendaBasica.titulo.setTextFormat(myTextFormat);

		leyendaBasica.titulo._x = ( chartContainerWidth / 2 ) - ( leyendaBasica.titulo._width / 2 ); ///< center title

		leyendaBasica.createTextField("active_value_name", leyendaBasica.getNextHighestDepth() , 0, leyendaBasica.titulo._height , chartContainerWidth, defaultLabelHeight);
		var myTextFormat:TextFormat = new TextFormat();
		myTextFormat.color = 0x5F5F5F;
		myTextFormat.font = "Arial";
		myTextFormat.size = font_size_name_value;
		myTextFormat.align = "center";
		leyendaBasica.active_value_name.text = this [ "chart_name_value" + chart_active_value ] ;
		leyendaBasica.active_value_name.selectable = false;
		leyendaBasica.active_value_name.autoSize = true;
		leyendaBasica.active_value_name.setTextFormat(myTextFormat);
		leyendaBasica.active_value_name._x = ( chartContainerWidth / 2 ) - ( leyendaBasica.active_value_name._width / 2 ); ///< center

		leyendaBasica.createTextField("subtitle", leyendaBasica.getNextHighestDepth() , 0, leyendaBasica.titulo._height + leyendaBasica.active_value_name._height , chartContainerWidth, defaultLabelHeight);

		var myTextFormat:TextFormat = new TextFormat();
		myTextFormat.color = 0x5F5F5F;
		myTextFormat.font = "Arial";
		myTextFormat.size = font_size_subtitle;
		myTextFormat.align = "center";
		leyendaBasica.subtitle.text = chart_subtitle;
		leyendaBasica.subtitle.selectable = false;
		leyendaBasica.subtitle.setTextFormat(myTextFormat);

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function cleanAll():Void { ///< before we refresh data, remove all movie clips

		axisClip.removeMovieClip();
		lineClip.removeMovieClip();
		chartContainerClip.tip.removeMovieClip();
		chartContainerClip.pieChartClip.removeMovieClip();
		chartContainerClip.barsChartClip.removeMovieClip();
		chartContainerClip.leyendaBasicaClip.removeMovieClip();


	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function initVars():Void {  ///< init all common variables

		timeCounter = 0;
		previousSeconds = 0;

		totalData = 0;

		drawingChart = true; ///< true while animation takes place

		chart_value = new Array();
		chart_value_secondary = new Array();

		if ( chart_active_value == 1 ) { ///< assign the right values depending on the active one
				chart_value = chart_value1;
				chart_value_secondary = chart_value2;
				name_value_active = chart_name_value1;
				name_value_secondary = chart_name_value2;
			}
			else
			{
				chart_value = chart_value2; ///< we will show this values on mouse over the bars or wedges
				chart_value_secondary = chart_value1;
				name_value_active = chart_name_value2;
				name_value_secondary = chart_name_value1;
			}



		chartContainerClip = this; ///< base clip where we draw all clips

		graphicalElementIncrement = new Array(); ///< store the current size increment of each chart element, for animation

		cleanAll(); ///< if we are refreshing data, remove all the clips before we put the new ones

		defaultLabelWidth = 70; ///< label default width. It's a temporal value, because the width of each label depends on the label content
		defaultLabelHeight = 20; ///< label default height. It's a temporal value, because the height of each label depends on the label content

		chartContainerX = 5;
		chartContainerY = 5;

		chartContainerHeight= Stage.height - chartContainerY - 10;
		chartContainerWidth = Stage.width - chartContainerX - 10;

		chartWidth = chartContainerWidth;
		chartHeight = chartContainerHeight - chartHeaderHeight - chartFooterHeight;

		dataValue = new Array();
		dataName = new Array();

		dataValue = chart_value;
		dataName = chart_data_name;

		totalData = dataValue.length - 1;

		if ( order_by_what != 0 ) orderData(order_by_what);	///< order values if was specified in XML file

		printBasicLegend(); ///< print the title and subtitle

		if (chartType == "pie") initPieChart();
		if (chartType == "bars") initBarsChart();

		depthIni = barsChartClip.getNextHighestDepth();

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function beautifyNumber(number:Number):String { ///< what does this? --> better an example: turns 3999439 into 3.999.439
		var temp:String;
		var result:String;
		var numberLength:Number;
		var startPoint:Number;
		var i:Number;

		temp = String(number);

		if(number > 999) { ///< only for numbers from 1000
			numberLength = temp.length;

			i = numberLength;
			do{ ///< firstly, we find out where should be the first dot
				i-=3;
			}while( i > 0 );

			startPoint = i+3;

			i = startPoint;

			///< put the first dot
			result = temp.substr(0, startPoint) + ".";

			do { ///< now the other ones
				result = result + (temp.substr(i,3)) + ".";
				i+=3;
			}while (i < numberLength);

			return(result.substr (0,(result.length - 1)));  ///< we remove the last, because we do not want 12.000.000.
		}
		else
			return(result = String(number)); ///< if number is smaller than 1000, we return the number as is

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function measuringTime():Void { ///< counting seconds until TIME_REFRESH, then reload XML file

		var timeCounterDate:Date = new Date();
		if (timeCounterDate.getSeconds() != previousSeconds) timeCounter++;
		previousSeconds = timeCounterDate.getSeconds();

		if(timeCounter > TIME_REFRESH ) {
					timeCounter = 0;
					gotoAndPlay("inicio");
		}

	}

	// --------------------------------------------------------------------------------------------------------------------------------------------

	function orderData(whichArray:Number):Void {  ///< order data by value specified in XML file

		var tempNumber:Number;
		var tempString:String;

		var tempArrayNumber1:Array = new Array();
		var tempArrayName1:Array = new Array();

		var tempArrayNumber2:Array = new Array();
		var tempArrayName2:Array = new Array();

		if ( whichArray == 1 ) {
			tempArrayNumber1 = dataValue;
			tempArrayName1 = dataName;
			tempArrayNumber2 = chart_value_secondary;
		}
		else
		{
			tempArrayNumber2 = dataValue;
			tempArrayName2 = dataName;
			tempArrayNumber1 = chart_value_secondary;
		}

		for (i = 1; i <= totalData; i++)	{

					for (j = i + 1 ; j <= totalData; j++) {
						if(order_criteria == "descending")  {
							if (tempArrayNumber1[j] > tempArrayNumber1[i]) {

								 tempNumber = tempArrayNumber1[i];
								 tempArrayNumber1[i] = tempArrayNumber1[j];
								 tempArrayNumber1[j] = tempNumber;

								 tempString = tempArrayName1[i];
								 tempArrayName1[i] = tempArrayName1[j];
								 tempArrayName1[j] = tempString;

								 tempNumber = tempArrayNumber2[i];
								 tempArrayNumber2[i] = tempArrayNumber2[j];
								 tempArrayNumber2[j] = tempNumber;

							}
						}
						else
						{
							if (tempArrayNumber1[j] < tempArrayNumber1[i]) {

								 tempNumber = tempArrayNumber1[i];
								 tempArrayNumber1[i] = tempArrayNumber1[j];
								 tempArrayNumber1[j] = tempNumber;

								 tempString = tempArrayName1[i];
								 tempArrayName1[i] = tempArrayName1[j];
								 tempArrayName1[j] = tempString;

								 tempNumber = tempArrayNumber2[i];
								 tempArrayNumber2[i] = tempArrayNumber2[j];
								 tempArrayNumber2[j] = tempNumber;

							}


						}

					}

		}



	}




	// --------------------------------------------------------------------------------------------------------------------------------------------
	// --------------------------------------------------------------------------------------------------------------------------------------------
	// --------------------------------------------------------------------------------------------------------------------------------------------
	// --------------------------------------------------------------------------------------------------------------------------------------------
	// --------------------------------------------------------------------------------------------------------------------------------------------
	// --------------------------------------------------------------------------------------------------------------------------------------------
	// --------------------------------------------------------------------------------------------------------------------------------------------
	// --------------------------------------------------------------------------------------------------------------------------------------------
	// --------------------------------------------------------------------------------------------------------------------------------------------
	// --------------------------------------------------------------------------------------------------------------------------------------------
	// --------------------------------------------------------------------------------------------------------------------------------------------
	// --------------------------------------------------------------------------------------------------------------------------------------------
	// MAIN PROGRAM


	initVars(); ///< initialize all variables


	// --------------------------------------------------------------------------------------------------------------------------------------------



	this.onEnterFrame = function() {


		if ( TIME_REFRESH != 0 ) measuringTime(); ///< counting seconds until next refresh

		if(chartType == "pie") {

				if(drawingChart) {

					drawingChart = false;  ///< by default, we suppose that we are not drawing the chart

					pieDepth = 1; ///< initial depth

					for(i=1;i<=totalData;i++) {  ///< while animation takes place, we paint wedges growing

						  if (pieWedgeSize[i] < dataGraphicalSize[i]) {

								graphicalElementIncrement[i] = ( (dataGraphicalSize[i] - pieWedgeSize[i]) / chart_animation_speed); ///< change increment value, to obtain a progressive animation

								if (graphicalElementIncrement[i] < 1) graphicalElementIncrement[i] = 1; ///< if increment is smaller than 1, force 1

								pieWedgeSize[i] += graphicalElementIncrement[i]; ///< increment size of each wedge

								drawingChart = true; ///< if we are inside this if, then we are drawing the chart

						  } else { ///< if we reached the desired vaule, force the wedge final value

							  pieWedgeSize[i] = dataGraphicalSize[i];

						  }

						  subtraction = (dataGraphicalSize[i] - pieWedgeSize[i]);

						  paintPieWedge(pieCenterX, pieCenterY, pieRadius - subtraction, pieWedgeDegreeIni[i], pieWedgeSize[i], i, 1);

					}

					pieWedgeClip = pieChartClip.createEmptyMovieClip("xx", pieWedgeClip.getNextHighestDepth());

					printPieLabels(); ///< print the labels of each wedge


					if ( ! drawingChart ) {	///< if we finished painting the wedges, print pie legend and enable the tooltips

						printPieLegend();
						enableChartTooltips();

					}

				}

		}



		if(chartType == "bars") {

				if(drawingChart) {

					drawingChart = false;  ///< by default, we suppose that we are not drawing the chart

					for (i = 1; i <= totalData; i++)	{   ///< while animation takes place, we paint bars growing

						  if(barSize[i]<dataGraphicalSize[i]) {

								graphicalElementIncrement[i] = ( (dataGraphicalSize[i] - barSize[i]) / chart_animation_speed); ///< change increment value, to obtain a progressive animation

								if (graphicalElementIncrement[i] < 1) graphicalElementIncrement[i] = 1;  ///< if increment is smaller than 1, force 1

								barSize[i]+=graphicalElementIncrement[i];

								drawingChart = true; ///< if we are inside this if, then we are drawing the chart

						  } else { ///< if we reached the desired value, force the wedge final value

							  barSize[i] = dataGraphicalSize[i];

							  dataNumberGrowing[i] = dataValue[i];

						  }

						 paintBar(( axisX +  ((i - 1) * barTotalWidth) + (barTotalWidth / 2 )-  (barWidth / 2)), axisY + axisHeight, barWidth, barSize[i],  i);

					}

					printBarLabelNumbers();  ///< print the number values above each bar

					if (drawingChart == false) { ///< if we finished painting the wedges, enable the tooltips

						enableChartTooltips();
					}

				}
		}

		if (!drawingChart) { ///< we finished the painting and buttons are enabled, so we must position the tip

			tipWorking();

		}


	}







