﻿/*
//------------------------------------------------------------------------
//------------------------------------------------------------------------

	charts_xml.as
	version 1.0

	Copyright (C) 2008, Juan Jesus G. Hinestrosa (soitu.es)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

	---------------------------------------

	This movie load charts.xml by default
	If you would rather use a different file name, use parameter xmlfile, for example: charts.swf?xmlfile=myfile.xml

//------------------------------------------------------------------------
//------------------------------------------------------------------------

*/

Stage.scaleMode =  "noScale"; ///< scale mode, we need this to avoid stretching
Stage.align = "TL"; ///< movie alignment ( Top Left )

var contextualMenu:ContextMenu = new ContextMenu(); ///< add credit in the movie contextual menu
contextualMenu.hideBuiltInItems();
_root.menu = contextualMenu;
contextualMenu.customItems[0] = new ContextMenuItem("Charts by soitu.es MET. v1.0", trace);


/* for xml parsing */
var chart_XML:XML = new XML();
chart_XML.ignoreWhite = true; ///< we need this to get rid of spaces, line feeds, etc
var xml_chart_parent:Array = new Array();
var xml_chart_data:Array = new Array();
var xml_chart_data_pieces:Array = new Array();
var xml_chart_colours:Array = new Array();
var xml_chart_font_sizes:Array = new Array();
var xml_chart_values:Array = new Array;




var chart_type:String; ///< chart type, bars or pie

var chart_data_name:Array = new Array(); ///< names for each piece of information
var chart_value1:Array = new Array();  ///< values for each piece of information  (primary)
var chart_value2:Array = new Array();   ///< values for each piece of information  (secondary)
var chart_active_value:Number; ///< define what value we are going to use to paint the chart (primary or secondary)

var chartBarsMaxValue:Number; ///< force max value in bars chart
var chartBarsMinValue:Number; ///< force min value in bars chart

/* see bars.png or pie.png in this folder to find out the placement of each value in the chart */
var chart_name_value1:String;
var chart_name_value2:String;
var chart_title:String;
var chart_subtitle:String;
var chartHeaderHeight:Number;
var chartFooterHeight:Number;
var pie_hole_size:Number;

var order_by_what:Number; ///< what value we have to order. 0 for none
var order_criteria:String; ///< ascending or descending

var colors:Array; 	///< colors of each wedge or bar
colors = new Array();

var rotateBarNumbers:Boolean = true;

var cont:Number = 0;

var TIME_REFRESH:Number = 0; ///< constant time in seconds defining the time between updates from XML file

/* font sizes */
var font_size_title:Number;
var font_size_subtitle:Number;
var font_size_name_value:Number;
var font_size_numbers:Number;
var font_size_labels:Number;
var font_size_tips:Number;
var font_size_pie_total:Number;


var chart_animation_speed:Number;  ///< show the total on the pie center, more is slower

var SHOW_PIE_TOTAL:Boolean;  ///< show the total number on the pie center


chart_XML.onLoad = function(success:Boolean) { ///< xml loaded successfully

		/** define default values **/
		chart_title =
		chart_subtitle =
		chart_name_value1 =
		chart_name_value2 = "";
		chart_type = "bars";
		chart_active_value = 1;
		order_by_what = 0;
		order_criteria = "descending";
		rotateBarNumbers = false;

		chart_animation_speed = 15;

		font_size_title = 18;
		font_size_subtitle = 11;
		font_size_name_value = 14;
		font_size_numbers = 11;
		font_size_labels = 11;
		font_size_tips = 11;
		font_size_pie_total = 20

		chartHeaderHeight = 50;
		chartFooterHeight = 60;

		chartBarsMaxValue = -1;
		chartBarsMinValue = 0;

		pie_hole_size = -1;

		SHOW_PIE_TOTAL = true;
		TIME_REFRESH = 0; ///< no refresh by default

         if (success) {

				xml_chart_parent = chart_XML.childNodes;

				for ( i = 0; i < xml_chart_parent.length ; i++ ) {

					if( xml_chart_parent[i].nodeName == "chart" ) {

						xml_chart_data = xml_chart_parent[i].childNodes;

						for (j = 0; j < xml_chart_data.length ; j++ ) {

							switch(xml_chart_data[j].nodeName) { ///< basic config

								case "name_value1" :  			chart_name_value1 = xml_chart_data[j].firstChild.nodeValue; break;
								case "name_value2" :  			if ( xml_chart_data[j].firstChild.nodeValue != undefined ) chart_name_value2 = xml_chart_data[j].firstChild.nodeValue; break;
								case "title" :  				chart_title = xml_chart_data[j].firstChild.nodeValue; break;
								case "subtitle" :  				chart_subtitle = xml_chart_data[j].firstChild.nodeValue; break;
								case "active_value" :  			chart_active_value = parseInt ( xml_chart_data[j].firstChild.nodeValue ); break;
								case "type" :  					chart_type = xml_chart_data[j].firstChild.nodeValue; break;
								case "rotate_bars_numbers" :	rotateBarNumbers =  ( xml_chart_data[j].firstChild.nodeValue == "true" ); break;
								case "pie_show_total" :			SHOW_PIE_TOTAL =  ( xml_chart_data[j].firstChild.nodeValue == "true" ); break;
								case "refresh_time" :			TIME_REFRESH =  parseInt ( xml_chart_data[j].firstChild.nodeValue ); break;

								case "order_by_what" : 			order_by_what = parseInt ( xml_chart_data[j].firstChild.nodeValue ); break;
								case "order_criteria" : 		order_criteria =  xml_chart_data[j].firstChild.nodeValue; break;

								case "chart_animation_speed" :	chart_animation_speed =  parseInt ( xml_chart_data[j].firstChild.nodeValue ); if (chart_animation_speed < 1) chart_animation_speed = 1; break;

								case "header_height" :			chartHeaderHeight =  parseInt ( xml_chart_data[j].firstChild.nodeValue ); break;
								case "pie_footer_height" :		chartFooterHeight =  parseInt ( xml_chart_data[j].firstChild.nodeValue ); break;

								case "pie_hole_size" :  		if ( xml_chart_data[j].firstChild.nodeValue == "auto" ) pie_hole_size = -1; else pie_hole_size = parseInt ( xml_chart_data[j].firstChild.nodeValue ); break;

								case "bars_chart_min_value" :	if ( xml_chart_data[j].firstChild.nodeValue != "auto" ) chartBarsMinValue = parseInt ( xml_chart_data[j].firstChild.nodeValue ); break;
								case "bars_chart_max_value" :	if ( xml_chart_data[j].firstChild.nodeValue != "auto" ) chartBarsMaxValue = parseInt ( xml_chart_data[j].firstChild.nodeValue ); break;

							}

							if ( xml_chart_data[j].nodeName == "colours" ) { ///< get colours palette

								xml_chart_colours =  xml_chart_data[j].childNodes;

								for (k = 0; k < xml_chart_colours.length ; k++ ) {

									if ( xml_chart_colours[k].nodeName == "colour" )  {

										colors.push ( parseInt ( xml_chart_colours[k].firstChild.nodeValue ) ) ;

									}

								}
							}

							if ( xml_chart_data[j].nodeName == "font_sizes" ) { ///< font sizes

								xml_chart_font_sizes =  xml_chart_data[j].childNodes;

								for (k = 0; k < xml_chart_font_sizes.length ; k++ ) {

									switch(xml_chart_font_sizes[k].nodeName) {

										case "title" :  	 	font_size_title = parseInt ( xml_chart_font_sizes[k].firstChild.nodeValue ) ; break;
										case "subtitle" :  	 	font_size_subtitle = parseInt ( xml_chart_font_sizes[k].firstChild.nodeValue ) ; break;
										case "name_value" :  	font_size_name_value = parseInt ( xml_chart_font_sizes[k].firstChild.nodeValue ) ; break;
										case "numbers" :  	 	font_size_numbers = parseInt ( xml_chart_font_sizes[k].firstChild.nodeValue ) ; break;
										case "labels" :  	 	font_size_labels = parseInt ( xml_chart_font_sizes[k].firstChild.nodeValue ) ; break;
										case "tips" :  	 		font_size_tips = parseInt ( xml_chart_font_sizes[k].firstChild.nodeValue ) ; break;
										case "pie_total" :  	font_size_pie_total = parseInt ( xml_chart_font_sizes[k].firstChild.nodeValue ) ; break;

									}
								}
							}


							if( xml_chart_data[j].nodeName == "chart_data" ) { ///< load data

								xml_chart_data_pieces =  xml_chart_data[j].childNodes;

								for (k = 0; k < xml_chart_data_pieces.length ; k++ ) {

									if( xml_chart_data_pieces[k].nodeName == "piece" )  {

										xml_chart_values =  xml_chart_data_pieces[k].childNodes;

										cont++;
										chart_value2[cont]	=
										chart_value1[cont] =	-1;

										for (l = 0; l < xml_chart_values.length ; l++ ) {

											switch(xml_chart_values[l].nodeName) {

												case "name" :  			chart_data_name[cont] = xml_chart_values[l].firstChild.nodeValue; break;
												case "value1" :  		chart_value1[cont] = parseInt ( xml_chart_values[l].firstChild.nodeValue ); break;
												case "value2" :  		chart_value2[cont] = parseInt (  xml_chart_values[l].firstChild.nodeValue ); break;

											}

										}

									}

								}
							}

						}

					}
				}

		chartType = chart_type;
		play();

	}
	else ///< error loading XML file, go to the keyframe labeled "xmlerror"
	{
			error_txt = "Aaah! Error! Can not find XML file (" + xmlfile + ")";
            gotoAndStop("xmlerror");

	}
}


if(!xmlfile) {	///< if no XML file was specified, use the default file name
	xmlfile = "chart.xml";
}


chart_XML.load(xmlfile); /// load XML, if you have not problems with browser or server cache
//chart_XML.load(xmlfile+"?uix="+(Math.floor(Math.random()*10000)));  ///< you should use this line instead if you are experiencing problems with cache







